<h1>A. Граф подстрок</h1>
<p><b>Время: 6 сек.<br>Память: 512 Мб</b></p>
<p>В свой первый рабочий день стажер Слава решил как следует изучить офис. Бродя по коридорам, Слава начал смотреть на английские названия переговорок.
   Вскоре он заметил, что названия переговорок имеют некий дисбаланс в буквосочетаниях - неужели в Яндексе изобрели какой-то свой диалект английского языка? Славу очень заинтересовала эта тема, поэтому он решил построить модель буквосочетаний и изучить его.</p>
<p>Первым делом данную модель необходимо построить. Слава выбрал формат графа:</p>
<ul>
	<li>название переговорки S = s<sub>1</sub>s<sub>2</sub>…s<sub>n−1</sub>s<sub>n</sub> образует n−2 буквосочетания длины 3: w<sub>1</sub>=s<sub>1</sub>s<sub>2</sub>s<sub>3</sub>, w<sub>2</sub>=s<sub>2</sub>s<sub>3</sub>s<sub>4</sub>,
	w<sub>3</sub>=s<sub>3</sub>s<sub>4</sub>s<sub>5</sub> …w<sub>n−2</sub>=s<sub>n−2</sub>s<sub>n−1</sub>s<sub>n</sub>; </li>
	<li>если для какого-то из буквосочетаний wi еще нет вершины в графе, то она создается; </li>
	<li>для каждой пары буквосочетаний (w<sub>i</sub>,w<sub>i+1</sub>) добавляется ориентированное ребро веса 1, или увеличивается вес существующего ребра на 1.</li>
</ul>

<p>Таким образом получается граф G с v вершинами и e ориентированными ребрами. Между некоторыми вершинами может быть несколько дуг (от a к b и от b к a).</p>
<p>Помогите Славе по заданному набору названий переговорок найти количество вершин в получившемся графе и вывести ориентированные ребра между вершинами.</p>


<h2>Формат ввода</h2>
<p>В первой строке записано одно целое число T (1 ≤ T ≤ 40000) — количество переговорок, которые встретил Слава по пути к рабочему месту.</p>
<p>В каждой из T следующих строк записано одно название переговорки S<sub>i</sub> (4 ≤ |S<sub>i</sub>| ≤ 30). Все названия состоят из строчных букв английского алфавита.</p>

<h2>Формат вывода</h2>
<p>В первой строке выведите количество вершин v в графе G.</p>
<p>Во второй строке выведите количество пар вершин e, между которыми есть ориентированные ребра.</p>
<p>В каждой из следующих e строк выведите слово w<sub>s</sub>, соответствующее началу ребра, затем слово w<sub>f</sub>, соответствующее концу ребра, и вес ориентированного ребра из вершины w<sub>s</sub> в w<sub>f</sub>.</p>
<p>Ребра вы можете перечислить в произвольном порядке.</p>

<h3>Примеры</h3>
<table>
  <thead>
     <tr>
        <th>Ввод</th>
        <th>Вывод</th>
     </tr>
  </thead>
  <tbody>
     <tr>
        <td>2<br />
            aaaaaaaaaaaaa<br />
            aaabbbaaabbba</td>
        <td>6<br />
            7<br />
            aaa aaa 10<br />
            aaa aab 2<br />
            aab abb 2<br />
            abb bbb 2<br />
            bbb bba 2<br />
            bba baa 1<br />
            baa aaa 1</td>
     </tr>
     <tr>
        <td>2<br />
            abab<br />
            baba</td>
        <td>2<br />
            2<br />
            aba bab 1<br />
            bab aba 1</td>
     </tr>
     <tr>
        <td>1<br />
            qwertyqwertyqwertyqwertyqwerty</td>
        <td>6<br />
            6<br />
            qwe wer 5<br />
            wer ert 5<br />
            ert rty 5<br />
            rty tyq 4<br />
            tyq yqw 4<br />
            yqw qwe 4</td>
     </tr>
  </tbody>
</table>
